<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuoteRequest extends Model
{
    use HasFactory;

    // Set a custom table name
    protected $table = 'customer_quote_requests';

    // Custom primary key
    protected $primaryKey = 'id';

    protected $fillable = [
        'first_name',
        'surname',
        'phone',
        'email',
        'city',
        'state',
        'postcode',
        'message',
        'product_name',
        'product_url',
        'product_price',
        'product_sku',
		'product_qty',
        'product_configuration',
        'token',
        'token_expires_at',
        'created_at',
        'updated_at'
    ];
}
