<?php

namespace App\Mail;

use App\Models\QuoteRequest;
use Illuminate\Bus\Queueable;                
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class QuoteRequestMail extends Mailable
{
    use SerializesModels; // harmless even if not queued

    public QuoteRequest $quote;

    public function __construct(QuoteRequest $quote)
    {
        $this->quote = $quote;
    }

    public function build()
    {
        $link = $this->quote->product_url 
      . '?SSID=' . $this->quote->token 
      . '&quantity=' . $this->quote->product_qty; 

        return $this->subject('Your Quote Request')
            ->markdown('emails.quotes.request', [
                'quote' => $this->quote,
                'link'  => $link,
            ]);
    }
}
