<?php

namespace App\Http\Controllers;

use App\Models\QuoteRequest;
use Illuminate\Http\Request;

class CustomerQuotesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $quotes = QuoteRequest::all();
        return view('quote.list', compact('quotes'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function view(string $id)
    {
        $quote = QuoteRequest::findOrFail($id);
        return view('quote.view', compact('quote'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validated();

        $updated_by = auth()->user()->name ?? 'admin';
        $request->merge(['updated_by' => $updated_by]);

        QuoteRequest::findOrFail($id)->update($request->all());

        return redirect()->route('quote.index')
            ->with('success', 'Quote updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
//        QuoteRequest::findOrFail($id)->delete();

        return redirect()->route('quote.index')
            ->with('success', 'Quote deleted successfully.');
    }
}
